# API-Dokumentation für den Import/Export zwischen externen Notenverwaltungsprogrammen und dem SaxSVS-Onlineschulmodul

- **`export.json`**:
    - Beschreibt eine REST-Schnittstelle für den Export von Daten aus dem SaxSVS-Onlineschulmodul zu
      externen Notenverwaltungsprogrammen. Dieser Export wird im SaxSVS-Onlineschulmodul durch den Nutzer initiiert. Der
      Nutzer wählt hierbei mindestens einen der unten aufgeführten Datenbereiche aus. Der Notenverwalter stellt die
      dafür benötigte Schnittstelle mittels eines HTTP-POST-Endpunktes bereit.
    - Die Authentifizierung erfolgt über einen API-Key, welcher vom jeweiligen Notenverwalter ausgegeben und im
      SaxSVS-Onlineschulmodul verwaltet wird. Der API-Key soll im HTTP-Header "X-API-Key" übertragen werden.
      Andere Authentifizierungsmechanismen auf Anfrage möglich.
    - Die Schnittstelle ist versioniert. Durch Angabe des Headers "X-API-Version" kann die jeweilige Version
      spezifiziert werden. Aktuell ist Version "1.0" verfügbar. Ist kein entsprechender Header angegeben, wird die
      aktuelle Version verwendet.
- **`import.json`**:
    - Beschreibt eine REST-Schnittstelle für den Import von Endnoten (Noten für Halb-/Jahreszeugnisse) von externen
      Notenverwaltungsprogrammen in das SaxSVS-Onlineschulmodul. Dieser Import wird im SaxSVS-Onlineschulmodul durch den
      Nutzer initiiert. Der Notenverwalter stellt die dafür benötigte Schnittstelle mittels eines HTTP-POST-Endpunktes
      bereit.
    - Die Authentifizierung erfolgt über einen API-Key, welcher vom jeweiligen Notenverwalter ausgegeben und im
      SaxSVS-Onlineschulmodul verwaltet wird. Der API-Key soll im HTTP-Header "X-API-Key" übertragen werden.
      Andere Authentifizierungsmechanismen auf Anfrage möglich.
    - Die Schnittstelle ist versioniert. Durch Angabe des Headers "X-API-Version" kann die jeweilige Version
      spezifiziert werden. Aktuell ist Version "1.0" verfügbar. Ist kein entsprechender Header angegeben, wird die
      aktuelle Version verwendet.

---

## Inhaltsverzeichnis

1. [Export](#export)
    - [Überblick](#überblick)
    - [Gemeinsame Basis-Regel extId](#gemeinsame-basis-regel-extid)
    - [Lehrer](#lehrer---teachers)
    - [Schüler](#schüler---students)
    - [Fremdsprachen](#fremdsprachen---foreignlanguages)
    - [Wahlfächer](#wahlfächer---electivesubjects)
    - [Weitere Informationen](#weitere-informationen-furthereducationalinformation)
    - [Persönliche Informationen](#persönliche-informationen---personalinformation)
    - [Sorgeberechtigte](#sorgeberechtigte---guardians)
    - [Klassen](#klassen---classes)
    - [Zuordnungen Klassen-Schüler](#zuordnungen-klassen-schüler---classesstudents)
    - [Unterrichtsgruppen](#unterrichtsgruppen---teachinggroups)
    - [Zuordnungen Klassen-Unterrichtsgruppen](#zuordnungen-klassen-unterrichtsgruppen---classesteachinggroups)
    - [Zuordnungen Schüler-Unterrichtsgruppen](#zuordnungen-schüler-unterrichtsgruppen---studentsteachinggroups)
    - [Beispiel (Export)](#beispiel-export)

2. [Import](#import)
    - [Überblick](#überblick-1)
    - [Endnoten-Request](#endnoten---request)
    - [Beispiel (Import-Request)](#beispiel-import-response)
    - [Endnoten-Restponse](#endnoten---response)
    - [Beispiel (Import-Response)](#beispiel-import-response)

---

## Export

### Überblick

- **Schema-Datei:** `export.json`
- **Wurzeltyp:** `object`
- **Beschreibung:** Export von Daten von Lehrkräften, Schülern, Erziehungsberechtigten, Klassen und/oder
  Unterrichtsgruppen
- **Aufruf:** Der Aufruf erfolgt über HTTP-POST an den vom Notenverwalter bereitgestellten Endpunkt. Der Body enthält
  ein JSON-Objekt, mit den jeweils zu exportierenden Datenbereichen.
- **Authentifizierung:** Erfolgt über den im HTTP-Header "X-API-Key" übermittelten API-Key.
- **Top-Level-Properties (optional, aber mind. eins nötig):**
    - `teachers` (Array)
    - `students` (Array)
    - `foreignLanguages` (Object: Map nach Schüler-extId)
    - `electiveSubjects` (Object: Map nach Schüler-extId)
    - `furtherEducationalInformation` (Object: Map nach Schüler-extId)
    - `personalInformation` (Object: Map nach Schüler-extId)
    - `guardians` (Object: Map nach Schüler-extId)
    - `classes` (Array)
    - `classesStudents` (Object: Map nach Klassen-extId)
    - `teachingGroups` (Array)
    - `classesTeachingGroups` (Object: Map nach Klassen-extId)
    - `studentsTeachingGroups` (Object: Map nach Schüler-extId)

### Gemeinsame Basis-Regel: `extId`

In vielen Bereichen wird `extId` als Identifikationsmerkmal eines Objekts verwendet. Über dieses kann das Objekt
im-/exportübergreifend für den einzelnen externen Notenverwalter eindeutig identifiziert werden. Eine Identifikation des
Objekts zwischen verschiedenen externen Notenverwaltern ist nicht möglich.

- **Typ:** `string`
- **Pattern:** `^[a-fA-F0-9]{64}$` (64-stelliger Hex-String)

---

### Lehrer - `teachers`

Eine Liste mit Informationen über die Lehrkräfte der Schule.

**Felder je Lehrkraft:**

| Feld           | Typ    | Einschränkungen             | Beschreibung                        |
|----------------|--------|-----------------------------|-------------------------------------|
| `extId`        | string | Pattern 64-hex, Pflichtfeld | Anbietereindeutige ID der Lehrkraft |
| `abbreviation` | string | maxLength 24, Pflichtfeld   | Kürzel                              |
| `namePrefix`   | string | maxLength 20                | Namenszusatz                        |
| `name`         | string | maxLength 30                | Nachname                            |
| `firstName`    | string | maxLength 30                | Vorname                             |

---

### Schüler - `students`

Eine Liste mit Informationen über die Schüler der Schule.

**Felder je Schüler:**

| Feld                | Typ    | Einschränkungen             | Beschreibung                                                                                              |
|---------------------|--------|-----------------------------|-----------------------------------------------------------------------------------------------------------|
| `extId`             | string | Pattern 64-hex, Pflichtfeld | Eindeutige ID des Schülers beim externen Anbieter                                                         |
| `uuid`              | string | Pattern 64-hex              | Eindeutige ID der Schülers innerhalb von SaxSVS **(Datenfeld nur noch bis 31.07.2026 enthalten!)**        |
| `namePrefix`        | string | maxLength 50                | Namenszusatz                                                                                              |
| `name`              | string | maxLength 150, Pflichtfeld  | Nachname                                                                                                  |
| `firstName`         | string | maxLength 150, Pflichtfeld  | Vorname                                                                                                   |
| `furtherFirstNames` | string | maxLength 150               | Weitere Vornamen                                                                                          |
| `gender`            | string | Enum, Pflichtfeld           | Geschlecht (`kurz` aus Enum [K101](https://web1.extranet.sachsen.de/svsp/public/schnittstellen/K101.xml)) |

---

### Fremdsprachen - `foreignLanguages`

Object-Map nach Schüler-extId. Enthält die vom jeweiligen Schüler gewählten Fremdsprachen.

- **Keys (`propertyNames`):** Schüler-`extId` (Pattern 64-hex)
- **Values (`additionalProperties`):** Objekt

**Felder je Schüler-Eintrag:**

| Feld         | Typ    | Beschreibung                                                                                                        |
|--------------|--------|---------------------------------------------------------------------------------------------------------------------|
| `first`      | string | 1. Fremdsprache (`kurz` aus Enum [StLa04](https://web1.extranet.sachsen.de/svsp/public/schnittstellen/StLa04.xml))  |
| `second`     | string | 2. Fremdsprache (`kurz` aus Enum [StLa04](https://web1.extranet.sachsen.de/svsp/public/schnittstellen/StLa04.xml))  |
| `third`      | string | 3. Fremdsprache (`kurz` aus Enum [StLa04](https://web1.extranet.sachsen.de/svsp/public/schnittstellen/StLa04.xml))  |
| `recognized` | string | Anerkannte Sprache (`lang` aus Enum [S1068](https://web1.extranet.sachsen.de/svsp/public/schnittstellen/S1068.xml)) |

---

### Wahlfächer - `electiveSubjects`

Object-Map nach Schüler-extId. Enthält die vom jeweiligen Schüler gewählten Wahlfächer.

- **Keys:** Schüler-`extId` (Pattern 64-hex)
- **Values:** Objekt

**Felder je Schüler-Eintrag:**

| Feld                          | Typ    | Einschränkungen | Beschreibung                                                                                                                                                                                                                           |
|-------------------------------|--------|----------------:|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `profile`                     | string |  maxLength 2000 | Profilname                                                                                                                                                                                                                             |
| `ethicsAndReligion`           | string |               – | Wahlfach Ethik/Religion<br>Enum [ "Evangelische Religion", "Katholische Religion", "Jüdische Religion", "Religion JG/ELF", "Ethik" ]<br>`lang` aus Enum [S0520](https://web1.extranet.sachsen.de/svsp/public/schnittstellen/S0520.xml) |
| `artAndMusic`                 | string |               – | Wahlfach Kunst/Musik<br>Enum [ "Kunst", "Musik" ]<br>`lang` aus Enum [S0520](https://web1.extranet.sachsen.de/svsp/public/schnittstellen/S0520.xml)                                                                                    |
| `homeEconomicsAndLaborTheory` | string |               – | Wahlfach Hauswirtschaft/Arbeitslehre<br>Enum [ "Technik/Computer", "Arbeitslehre", "Hauswirtschaft" ]<br>`lang` aus Enum [S0520](https://web1.extranet.sachsen.de/svsp/public/schnittstellen/S0520.xml)                                |

---

### Weitere Informationen `furtherEducationalInformation`

Object-Map nach Schüler-extId. Enthält weitere Informationen über den jeweiligen Schüler.

- **Keys:** Schüler-`extId` (Pattern 64-hex)
- **Values:** Objekt

**Felder je Schüler-Eintrag:**

| Feld                 | Typ           | Beschreibung                                                                                                           |
|----------------------|---------------|------------------------------------------------------------------------------------------------------------------------|
| `educationalProgram` | string (Enum) | Bildungsgang/Programm (`kurz` aus Enum [S1070](https://web1.extranet.sachsen.de/svsp/public/schnittstellen/S1070.xml)) |
| `promotionalSport`   | string        | Förder-/Leistungssport                                                                                                 |

---

### Persönliche Informationen - `personalInformation`

Object-Map nach Schüler-extId. Enthält persönliche Informationen über den jeweiligen Schüler.

- **Keys:** Schüler-`extId` (Pattern 64-hex)
- **Values:** Objekt

**Felder je Schüler-Eintrag:**

| Feld              | Typ    | Einschränkungen                      | Beschreibung                        |
|-------------------|--------|--------------------------------------|-------------------------------------|
| `dateOfBirth`     | string | format `date`, Länge 10, Pflichtfeld | Geburtsdatum im Format `YYYY-MM-DD` |
| `placeOfBirth`    | string | maxLength 150                        | Geburtsort                          |
| `address`         | object | –                                    | Postadresse                         |
| `emergencyNumber` | string | maxLength 100                        | Notfall-Telefonnummer               |

**`address` Felder:**

| Feld          | Typ    | Einschränkungen |
|---------------|--------|-----------------|
| `street`      | string | maxLength 100   |
| `houseNumber` | string | maxLength 20    |
| `zipCode`     | string | maxLength 10    |
| `place`       | string | maxLength 256   |

---

### Sorgeberechtigte - `guardians`

Object-Map nach Schüler-extId. Enthält Informationen zu den Sorgeberechtigten des jeweiligen Schülers.

- **Keys:** Schüler-`extId` (Pattern 64-hex)
- **Values:** `array`

**Felder je Sorgeberechtigten:**

| Feld           | Typ           | Einschränkungen             | Beschreibung                                                                                            |
|----------------|---------------|-----------------------------|---------------------------------------------------------------------------------------------------------|
| `extId`        | string        | Pattern 64-hex, Pflichtfeld | Eindeutige ID des Sorgeberechtigten                                                                     |
| `custodial`    | boolean       | –                           | `true` = personensorgeberechtigt                                                                        |
| `firstName`    | string        | maxLength 150               | Vorname                                                                                                 |
| `name`         | string        | maxLength 150               | Nachname                                                                                                |
| `salutation`   | string (Enum) | –                           | Anrede (`lang` aus Enum [S1000](https://web1.extranet.sachsen.de/svsp/public/schnittstellen/S1000.xml)) |
| `phonePrivate` | string        | maxLength 100               | Telefon privat                                                                                          |
| `phoneWork`    | string        | maxLength 100               | Telefon dienstlich                                                                                      |
| `emailPrivate` | string        | maxLength 256               | E-Mail privat                                                                                           |
| `emailWork`    | string        | maxLength 256               | E-Mail dienstlich                                                                                       |

---

### Klassen - `classes`

Enthält Informationen zu den Klassen der Schule.

**Felder je Klasse:**

| Feld      | Typ           | Einschränkungen             | Beschreibung                                                                                                                                                                                                                                                              |
|-----------|---------------|-----------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `extId`   | string        | Pattern 64-hex, Pflichtfeld | Eindeutige Klassen-ID                                                                                                                                                                                                                                                     |
| `name`    | string        | maxLength 100, Pflichtfeld  | Klassenname                                                                                                                                                                                                                                                               |
| `grade`   | string (Enum) | Pflichtfeld                 | Jahrgangsstufe (`kurz` aus Enum [S0540](https://web1.extranet.sachsen.de/svsp/public/schnittstellen/S0540.xml))                                                                                                                                                           |
| `type`    | string (Enum) | maxLength 30, Pflichtfeld   | Typ-Kombination SCHOOL_TYPE:GRADE:ADDITION<br/><br/>SCHOOL_TYPE: `kurz` aus Enum [S0501](https://web1.extranet.sachsen.de/svsp/public/schnittstellen/S0501.xml)<br/>GRADE: `kurz` aus Enum [S0540](https://web1.extranet.sachsen.de/svsp/public/schnittstellen/S0540.xml) |
| `teacher` | string        | Pattern 64-hex              | Klassenlehrkraft-extId                                                                                                                                                                                                                                                    |

---

### Zuordnungen Klassen-Schüler - `classesStudents`

Object-Map nach Klassen-extId. Enthält die Zuordnung von Klassen zu Schülern (Versetzungen).

- **Keys:** Klassen-`extId` (Pattern 64-hex)
- **Values:** Objekt mit Property `type` (Array)

---

### Unterrichtsgruppen - `teachingGroups`

Enthält Informationen zu den Unterrichtsgruppen der Schule.

- **items:** Objekt (Unterrichtsgruppe)
- **required:** `["extId", "type", "ba"]`

**Felder je Teaching Group:**

| Feld         | Typ           | Einschränkungen             | Beschreibung                                                                                                     |
|--------------|---------------|-----------------------------|------------------------------------------------------------------------------------------------------------------|
| `extId`      | string        | Pattern 64-hex, Pflichtfeld | Gruppen-ID                                                                                                       |
| `name`       | string        | maxLength 250               | Name (bei Typ `KL` ggf. leer/ohne Namen)                                                                         |
| `type`       | string (Enum) | Pflichtfeld                 | Gruppentyp: aus Enum `K`, `KL`, `M`, `S`                                                                         |
| `amtlKurz`   | string (Enum) | –                           | Amtl. Kurz (`kurz` aus Enum [S0520](https://web1.extranet.sachsen.de/svsp/public/schnittstellen/S0520.xml))      |
| `ba`         | string (Enum) | Pflichtfeld                 | Bildungsangebot (`kurz` aus Enum [S0520](https://web1.extranet.sachsen.de/svsp/public/schnittstellen/S0520.xml)) |
| `internLang` | string        | maxLength 250               | Schulinterne Bezeichnung                                                                                         |
| `teacher`    | string        | Pattern 64-hex              | Lehrkraft-extId                                                                                                  |

---

### Zuordnungen Klassen-Unterrichtsgruppen - `classesTeachingGroups`

Object-Map nach Klassen-extId. Enthält Zuordnungen zwischen Klassen und Unterrichtsgruppen.

- **Keys:** Klassen-`extId` (Pattern 64-hex)
- **Values:** Objekt mit Property `type` (Array)

---

### Zuordnungen Schüler-Unterrichtsgruppen - `studentsTeachingGroups`

Object-Map nach Schüler-extId. Enthält Zuordnungen zwischen Schülern und Unterrichtsgruppen.

- **Keys:** Schüler-`extId` (Pattern 64-hex)
- **Values:** Objekt mit Property `type` (Array)

---

### Beispiel (Export)

```json
{
  "teachers": [
    {
      "extId": "409e4916ef176b3583ddaa914a4bd9d5adc0840d6f13d9c60d3ed4e5d7444995",
      "abbreviation": "X0031",
      "name": "Fiedler",
      "firstName": "Adolf"
    },
    {
      "extId": "2241660d6d1ddb77e0b77175a237ef8c17929af8dc104aa8d8cb100fdd8393c4",
      "abbreviation": "X0026",
      "name": "Schmitt",
      "firstName": "Edda"
    },
    {
      "extId": "b6e74c93bca636d9758fe092677c7087a30a24173557e1972b90e82d051dc5d2",
      "abbreviation": "X0022",
      "name": "Weber",
      "firstName": "Caroline"
    }
  ],
  "students": [
    {
      "extId": "8edab76af08fee1ffb10ea59f259b2f0c5571c6fba340e259d27eb0c1d153218",
      "uuId": "45c18a18-60a0-15f8-e063-2a6810ac1751",
      "name": "Baer",
      "firstName": "Moritz",
      "gender": "männl."
    }
  ],
  "foreignLanguages": {
    "8edab76af08fee1ffb10ea59f259b2f0c5571c6fba340e259d27eb0c1d153218": {
      "first": "Englisch"
    }
  },
  "electiveSubjects": {
    "8edab76af08fee1ffb10ea59f259b2f0c5571c6fba340e259d27eb0c1d153218": {
      "ethicsAndReligion": "Ethik",
      "artAndMusic": "Kunst"
    }
  },
  "furtherEducationalInformation": {
    "8edab76af08fee1ffb10ea59f259b2f0c5571c6fba340e259d27eb0c1d153218": {
      "educationalProgram": "RS"
    }
  },
  "personalInformation": {
    "8edab76af08fee1ffb10ea59f259b2f0c5571c6fba340e259d27eb0c1d153218": {
      "dateOfBirth": "2009-07-14",
      "placeOfBirth": "Cottbus",
      "address": {
        "street": "Anne-Frank-Straße",
        "houseNumber": "198",
        "place": "Oberhermsdorf"
      }
    }
  },
  "guardians": {
    "8edab76af08fee1ffb10ea59f259b2f0c5571c6fba340e259d27eb0c1d153218": [
      {
        "extId": "f00fa0e40150d14ba20c0f9f3a5ceeacc7fbcae58c5842b6ad77ed858330d157",
        "custodial": true,
        "firstName": "Cornelia",
        "name": "Baer",
        "salutation": "Frau",
        "phonePrivate": "0351/79997100",
        "phoneWork": "0351/79997100",
        "emailPrivate": "support@statistik.sachsen.de",
        "emailWork": "support@statistik.sachsen.de"
      },
      {
        "extId": "0043964ee854d4f3f462238bbf449ae4d643c594d884a9c644a7c6462c21cc01",
        "custodial": true,
        "firstName": "André",
        "name": "Baer",
        "salutation": "Herr",
        "phonePrivate": "0351/79997100",
        "phoneWork": "0351/79997100",
        "emailPrivate": "support@statistik.sachsen.de",
        "emailWork": "support@statistik.sachsen.de"
      }
    ]
  },
  "classes": [
    {
      "extId": "c0c5be9965a899b31f94bdfb4f63eccfb81973739f4d383b19699845e590d424",
      "name": "10/1",
      "grade": "KL10",
      "type": "OS:KL10",
      "teacher": "409e4916ef176b3583ddaa914a4bd9d5adc0840d6f13d9c60d3ed4e5d7444995"
    }
  ],
  "classesStudents": {
    "c0c5be9965a899b31f94bdfb4f63eccfb81973739f4d383b19699845e590d424": [
      "8edab76af08fee1ffb10ea59f259b2f0c5571c6fba340e259d27eb0c1d153218"
    ]
  },
  "teachingGroups": [
    {
      "extId": "ab66b67a9a1b126c80b53a517b5e4aa8876a9a232ed1928e89838437bc31b7eb",
      "name": "INF12644910",
      "type": "K",
      "amtlKurz": "INF",
      "ba": "INF",
      "internLang": "Informatik",
      "teacher": "b6e74c93bca636d9758fe092677c7087a30a24173557e1972b90e82d051dc5d2"
    },
    {
      "extId": "171b073540a52da5b3e6e3fd83d283dfba30883555bcfa1ed43f59e1aa99a275",
      "type": "KL",
      "amtlKurz": "MA",
      "ba": "MA",
      "internLang": "Mathematik",
      "teacher": "409e4916ef176b3583ddaa914a4bd9d5adc0840d6f13d9c60d3ed4e5d7444995"
    },
    {
      "extId": "9580b428fad0cc4aceee3d39a86b505f0291d163a61f3fc0e55090b8d0cb6bb8",
      "name": "SPO12644902",
      "type": "S",
      "amtlKurz": "SPO",
      "ba": "SPO",
      "internLang": "Sport",
      "teacher": "b6e74c93bca636d9758fe092677c7087a30a24173557e1972b90e82d051dc5d2"
    }
  ],
  "classesTeachingGroups": {
    "c0c5be9965a899b31f94bdfb4f63eccfb81973739f4d383b19699845e590d424": [
      "171b073540a52da5b3e6e3fd83d283dfba30883555bcfa1ed43f59e1aa99a275",
      "ab66b67a9a1b126c80b53a517b5e4aa8876a9a232ed1928e89838437bc31b7eb",
      "9580b428fad0cc4aceee3d39a86b505f0291d163a61f3fc0e55090b8d0cb6bb8"
    ]
  },
  "studentsTeachingGroups": {
    "8edab76af08fee1ffb10ea59f259b2f0c5571c6fba340e259d27eb0c1d153218": [
      "171b073540a52da5b3e6e3fd83d283dfba30883555bcfa1ed43f59e1aa99a275",
      "ab66b67a9a1b126c80b53a517b5e4aa8876a9a232ed1928e89838437bc31b7eb",
      "9580b428fad0cc4aceee3d39a86b505f0291d163a61f3fc0e55090b8d0cb6bb8"
    ]
  }
}
```

---

## Import

### Überblick

- **Schema-Datei:** `import.json`
- **Wurzeltyp:** `object`
- **Beschreibung:** Import von Endnoten je Schüler
- **Aufruf:** Der Aufruf erfolgt über HTTP-POST an den vom Notenverwalter bereitgestellten Endpunkt. Der Body enthält
  ein JSON-Objekt, mit allen Schüler-ExtIds, für die der Abruf der Endnoten erfolgen soll.
- **Authentifizierung:** Erfolgt über den im HTTP-Header "X-API-Key" übermittelten API-Key.

### Endnoten - Request

JSON-Objekt "extIds" mit Array aller Schüler-extIds, deren Endnoten importiert werden sollen.

#### Beispiel (Import-Request)

```json
{
  "extIds": [
    "8edab76af08fee1ffb10ea59f259b2f0c5571c6fba340e259d27eb0c1d153218",
    "8edab76af08fee1ffb10ea59f259b2f0c5571c6fba340e259d27eb0c1d153219"
  ]
}
```

---

### Endnoten - Response

Array der Endnoten von Schülern

**Felder je Endnoten-Eintrag:**

| Feld      | Typ           | Einschränkungen                        | Beschreibung                                                                                          |
|-----------|---------------|----------------------------------------|-------------------------------------------------------------------------------------------------------|
| `extId`   | string        | Pattern 64-hex, Pflichtfeld            | Schüler-ID des externen Anbieters                                                                     |
| `subject` | string (Enum) | Pflichtfeld                            | Fach (`kurz` aus Enum [S0520](https://web1.extranet.sachsen.de/svsp/public/schnittstellen/S0520.xml)) |
| `grade`   | string        | minLength 1, maxLength 20, Pflichtfeld | Note (als Text)                                                                                       |

#### Beispiel (Import-Response)

```json
{
  "finalGrades": [
    {
      "extId": "8edab76af08fee1ffb10ea59f259b2f0c5571c6fba340e259d27eb0c1d153218",
      "subject": "INF",
      "grade": "1"
    },
    {
      "extId": "8edab76af08fee1ffb10ea59f259b2f0c5571c6fba340e259d27eb0c1d153218",
      "subject": "MA",
      "grade": "2"
    },
    {
      "extId": "8edab76af08fee1ffb10ea59f259b2f0c5571c6fba340e259d27eb0c1d153218",
      "subject": "SPO",
      "grade": "2+"
    }
  ]
}
```